    const frontLoc = Vector.add(source.location, Vector.multiply(source.getViewDirection, 1));
            const projectile = world.getDimension("overworld").spawnEntity("pixel:slash_crescent",frontLoc)
            projectile.setVelocity(new Vector(player.viewVector.x, player.viewVector.y, player.viewVector.z));
            
                 let targeter = system.runInterval(() =>{
                  let tgt = source.getEntitiesFromViewDirection({maxDistance: 7})[0];
                  let tgtr = fetchScore(source, "tgtr");
                  if (tgtr != 1) {
                    system.clearRun(targeter);
                  } else {
                      tgt.runCommandAsync("execute at @s run particle evoker_spell ~~~")
                  }
               });
            
world.events.itemUse.subscribe(ev => {
  const { source: player } = ev;
  shoot(player,'minecraft:arrow',20,0.001)
  let CD = 20 * 2
  const reload = system.runSchedule( () => {
    if (CD-- < 0){
      return system.clearRunSchedule(reload)
    }
    shoot(player,'minecraft:tnt',20,0.1)
  })
})

/**
 * 
 * @param {Entity} source 
 * @param {string} projectile 
 * @param {number} offset 
 * @param {number} speed 
 * @returns 
 */
function shoot(source, projectile, speed, offset = 0) {
  const {
    dimension,
    headLocation:{x:hX,y:hY,z:hZ},
    viewDirection:{x:vX,y:vY,z:vZ},
    rotation:{x:xRot,y:yRot}
  } = source;
  const evLocation = new Location(hX+vX,hY+vY,hZ+vZ);
  const entity = dimension.spawnEntity(projectile, evLocation);
  entity.setRotation(-xRot, -yRot)
  const newVec = vectorOffset({x:vX,y:vY,z:vZ},offset)
  entity.setVelocity(Vector.multiply(newVec,speed))
  return {vector:newVec}
}

function vectorOffset(viewVector = new Vector(0,0,0),value=0) {
  const float = 10000
  const {x,y,z} = Vector.multiply(viewVector,float)
  const rand = () => Math.random() * (value + value) - value
  const newVector = new Vector(
    x+rand(),
    y+rand(),
    z+rand()
  );
  return Vector.divide(newVector,float)
}


import { world, system, MolangVariableMap, Player, Vector } from "@minecraft/server";


const { cross, slerp, lerp, subtract, add, divide, multiply, distance,
    zero, one, forward, back, right, left, up, down } = Vector
    
const { itemStartCharge, itemStopCharge } = world.events

itemStartCharge.subscribe(start => {
    const { source } = start;

    const runId = system.runInterval(() => {
        const { dimension } = source;
        const head = source.getHeadLocation();
        const view = source.getViewDirection();
        const loc = lerp(
            head,
            add(head, view),
            5
        );
        console.warn(JSON.stringify({
            x: Number(view.x.toFixed(3)),
            y: Number(view.y.toFixed(3)),
            z: Number(view.z.toFixed(3)),

        }, null, 3));
        dimension.spawnParticle('minecraft:endrod', loc, new MolangVariableMap())
    }, 2);

    const stopEv = itemStopCharge.subscribe(ev => {
        if (ev.source !== source) return;
        system.clearRun(runId);
        itemStopCharge.unsubscribe(stopEv);
    });
});